/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;

public class MaterialFlowDetailTableRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long date;
    private final double change;
    private final double remains;
    private final boolean completion;
    private final MaterialFlowInnerData source;
    private final MaterialFlowInnerData destination;

    public MaterialFlowDetailTableRow(long date, double change, double remains, boolean completion, MaterialFlowInnerData source, MaterialFlowInnerData destination) {
        this.date = date;
        this.change = change;
        this.remains = remains;
        this.completion = completion;
        this.source = source;
        this.destination = destination;
    }

    public long getDate() {
        return this.date;
    }

    public double getChange() {
        return this.change;
    }

    public double getRemains() {
        return this.remains;
    }

    public boolean isCompletion() {
        return this.completion;
    }

    public MaterialFlowInnerData getSource() {
        return this.source;
    }

    public MaterialFlowInnerData getDestination() {
        return this.destination;
    }

    public long getDateDifference() {
        if (!GeneralizedRequest.isDateValid(this.destination.getDate())) {
            return -9223372036854775708L;
        }
        if (!GeneralizedRequest.isDateValid(this.source.getDate())) {
            return -9223372036854775708L;
        }
        return this.destination.getDate() - this.source.getDate();
    }

    public static class MaterialFlowInnerData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Object origin;
        private final String originName;
        private boolean fresh;
        private final long date;
        private double qty;
        private double remains;
        private final String note;
        private transient Set<StoreActivity> sas;

        public MaterialFlowInnerData(Object origin, String originName, boolean fresh, long date, double change, String note, Set<StoreActivity> sas) {
            this(origin, originName, fresh, date, change, Double.NaN, note, sas);
        }

        public MaterialFlowInnerData(Object origin, String originName, boolean fresh, long date, double change, double remains, String note, Set<StoreActivity> sas) {
            this.origin = origin;
            this.originName = originName;
            this.fresh = fresh;
            this.date = date;
            this.qty = change;
            this.remains = remains;
            this.note = note;
            this.sas = sas;
        }

        public Object getOrigin() {
            return this.origin;
        }

        public String getName() {
            return this.originName;
        }

        public boolean isFresh() {
            return this.fresh;
        }

        public long getDate() {
            return this.date;
        }

        public double getQty() {
            return this.qty;
        }

        public String getNote() {
            return this.note;
        }

        public double getRemains() {
            return this.remains;
        }

        public void setRemains(double remains) {
            this.remains = remains;
        }

        public void setFresh(boolean fresh) {
            this.fresh = fresh;
        }

        public void setQty(double change) {
            this.qty = change;
        }

        public double getRatio() {
            if (this.remains < 0.0 && this.qty < 0.0 || this.remains > 0.0 && this.qty > 0.0) {
                return ReportUtilities.getSafeRatio(this.remains, this.qty);
            }
            return 0.0;
        }

        public Set<StoreActivity> getSas() {
            return this.sas;
        }

        private void writeObject(ObjectOutputStream ignored) throws IOException {
            throw new UnsupportedOperationException("The " + this.getClass().getSimpleName() + " cannot be serialized.");
        }
    }
}

